
#ifndef CMRCONTROLLERMGR_H
#define CMRCONTROLLERMGR_H

#include <list>
#include <map>
#include "CMRControllerImpl.h"
#include "services/interface/CMRMeetingCallback.h"
#include "csf/RWLock.hpp"
#include "CMRControllerDef.h"

namespace CSFUnified
{
	class CSFUNIFIED_API CMRControllerMgr
    {
	public:
        CMRControllerMgr(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
		~CMRControllerMgr();
		
        void start();
        void stop();
		SMART_PTR_NS::shared_ptr<CMRControllerImpl> getCMRController(const std::string JID);
		void onPMRPropertyChange(bool isSendNotice, bool isCMREnable, CMRProperty& property);
		void clearUnusedCMRController();
		void registerCallback(SMART_PTR_NS::shared_ptr<CMRMeetingCallback> callback);
		void unregisterCallback(SMART_PTR_NS::shared_ptr<CMRMeetingCallback> callback);

		void sendCMRMeetingStarted(bool isSuccess, std::string JID);
		void sendMeetingStarted(CMRMeetingErrorCodeEnum::CMRMeetingErrorCode errCode, std::string JID);
		void sendMeetingJoined(CMRMeetingErrorCodeEnum::CMRMeetingErrorCode errCode, std::string JID);
		void sendMeetingEnded(std::string JID);

        void onCmrMeetingStarted(const CMRMeetingData& info);
        void onCmrMeetingJoined();
        void onCmrMeetingEnded();
        void onCmrMeetingError();


	private:
		bool isCMREnable();
        void fireCMRProertyChange(bool isCMREnable, bool isSendNotice);
		void sendMeetingInvitationToLagecyClient(std::string JID, std::string joinUrl, std::string sipUrl);
        std::string encodeURL(std::string url);

	private:
        SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
		std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> > m_listCallback;
		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> > m_mapCMRCtrl;
		CMRProperty m_property;
        csf::RWLock mLock;
    };
    
}

#endif
